<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductSpecification extends Model
{
    protected $fillable = [
        'product_id',
        'spec_name',
        'spec_value',
        'spec_unit',
    ];

    public function product(): BelongsTo
    {
        return $this->belongsTo(ProductMaster::class, 'product_id');
    }
}
